/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;

public class SonarLintProject {
    private final IProject project;
    private List<SonarLintProperty> extraProperties = new ArrayList<SonarLintProperty>();
    private String moduleKey;
    private String serverId;
    private boolean autoEnabled = true;

    public SonarLintProject(IProject project) {
        this.project = project;
    }

    public static SonarLintProject getInstance(IResource resource) {
        IProject project = resource.getProject();
        if (project == null || !project.isAccessible()) {
            throw new IllegalStateException("Unable to find project for resource " + resource);
        }
        return SonarLintCorePlugin.getDefault().getProjectManager().readSonarLintConfiguration(project);
    }

    public void save() {
        SonarLintCorePlugin.getDefault().getProjectManager().saveSonarLintConfiguration(this.project, this);
    }

    public IProject getProject() {
        return this.project;
    }

    public List<SonarLintProperty> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(List<SonarLintProperty> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public boolean isBuilderEnabled() {
        IProjectDescription desc;
        try {
            desc = this.project.getDescription();
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to read project description", e);
        }
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.sonarlint.eclipse.core.sonarlintBuilder")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setBuilderEnabled(boolean enabled) {
        if (enabled && !this.isBuilderEnabled()) {
            this.addBuilder();
        } else if (!enabled && this.isBuilderEnabled()) {
            this.removeBuilder();
        }
    }

    private void removeBuilder() {
        try {
            IProjectDescription desc = this.project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int i = 0;
            ICommand[] iCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand previousCommand = iCommandArray[n2];
                if (!previousCommand.getBuilderName().equals("org.sonarlint.eclipse.core.sonarlintBuilder")) {
                    newCommands[i] = previousCommand;
                    ++i;
                }
                ++n2;
            }
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to add builder", e);
        }
    }

    private void addBuilder() {
        try {
            IProjectDescription desc = this.project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.sonarlint.eclipse.core.sonarlintBuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = command;
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to add builder", e);
        }
    }

    public String getModuleKey() {
        return StringUtils.trimToNull(this.moduleKey);
    }

    public String getServerId() {
        return StringUtils.trimToNull(this.serverId);
    }

    public void setModuleKey(String moduleKey) {
        this.moduleKey = moduleKey;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void update(IProgressMonitor monitor) {
        IServer server = ServersManager.getInstance().getServer(this.getServerId());
        if (server == null) {
            SonarLintCorePlugin.getDefault().error("Unable to update project '" + this.project.getName() + "' since it is bound to an unknow server: '" + this.getServerId() + "'");
            return;
        }
        server.updateProject(this.moduleKey);
    }

    public boolean isBound() {
        return this.getServerId() != null && this.getModuleKey() != null;
    }

    public boolean isAutoEnabled() {
        return this.autoEnabled;
    }

    public void setAutoEnabled(boolean autoEnabled) {
        this.autoEnabled = autoEnabled;
    }
}

